NB. ----------------------------------------------------------------------------
NB. J Wicked Tacit Toolkit...
NB. ----------------------------------------------------------------------------
   
NB. DO NOT TRY TO LOAD THIS SCRIPT!!!  
NB. Instead, run it using 0!:0, or similar, or paste 
NB. it on an J editing window and use Crtl-A Crtl-E, or
NB. of course, run the script using a hot key

NB. (0!:0)<'/.../J Wicked Toolkit.js_'
   
NB. WARNING: This tookit relies unorthodox (theoretically illegal) constructions
NB. which make possible to cloak adverbs and conjunctions as verbs; thus, 
NB. effectively making higher-order functions (i.e., allowing tacit verbs be  
NB. be able to take verbs, adverbs and conjunctions as arguments and produce 
NB. verbs, adverbs and conjunctions)

NB. Word means noun, verb, adverb or conjunction

JVERSION

(_ o=. @:) (c=. "_) (e=. &.>) (x=. @:[) (y=. @:]) (p=. &:>/) (q=. @:(,&:<))

j=. ,&:<  NB. Joining (dyadic verb)
an=.  <@:((,'0') j ])f.  NB. Atomizing words (monadic verb)

tm=. , ((2 (#.\"1) 0 ,. (] </~ i.@:(-@:(>./)))@:(+/\@:(=/\@:('''' ~: ]) * 1 _1 0 {~ '()' i. ]))) { ' ' , 6 8 10 { 9!:6@:(''"_))
  NB. Tacit map (dyadic verb)
  NB. (e.g., tm (5!:5)<'tm' )

for=. ("1)(@:(>@:{))  NB. For (adv)
  assert (< for 1 ; 2 3 ; 4 5 6) -: 2 3$1 2 4;1 2 5;1 2 6;1 3 4;1 3 5;1 3 6

Wrap=.-@:[ ]\ 5!:5@<@:]  NB. (dyadic verb)

(lr=. 5!:5@(<^:(L. = 0:))) (ar=. 5!:1@(<^:(L. = 0:)))

NB. Ver and ver...

Ver=. (0:`)(,^:)
  NB. Verbing (the atomic representations of)
  NB. adverbs or conjunctions as monadic or
  NB. dyadic verbs; a transient definition (adv)
Ver=. ((5!:1)@:<'Ver')Ver  NB. Ver verbing itself!

ver=. Ver o an f. 


Ver=. (0&{::^:(1 -: #)) o (< o Ver o (an o (Ver<'f.') o > :: <)"0) o ;: f.
  NB. Verbing and fixing quoted primitives and pro-adverbs or pro-conjunctions (monadic verb)
  NB.
  NB. 0&{:: instead of > to avoid J807 crashes due to the enforcement of rank 0 for verbs 
  NB. Ver=. (>^:(1 -: #)) o (< o Ver o (an o (Ver<'f.') o > :: <)"0) o ;: f.
  NB. (>^:(1 -: #)) o (< o Ver o (af              o > :: <)"0) o ;: f. 
  NB. Verbing and fixing quoted primitives and pro-adverbs or pro-conjunctions (monadic verb)

'evoke fix'=. Ver '`: f.' NB. Verbing evoke(`:) and fix (f.)

'amper at evoke fix rank tie'=. Ver '& @: `: f. " `'
  NB. Verbing...
  NB. &  - bond  (monadic), compose (dyadic)
  NB. @: -                  at      (dyadic)
  NB. `: - evoke (monadic)
  NB. f. - fix    (monadic)
  NB. "  -                  rank    (dyadic)
  NB. `  -                  tie     (dyadic)

train=. (evoke&6) :. an f.
  NB. (`:6) with a convenient obverse (monadic verb)

box=. (< o train "0) f.  NB. Boxing primitives and pro-words (monadic verb)

of=. train o ([ ; an y) f. NB. Evaluating a verb-noun gerundial (or similar) form
  assert ((    *:`'') of 1 2 3) -: 1 4 9
  assert ((box *:`'') of 1 2 3) -: 1 4 9

af=. an o fix f. NB. Atomizing after fixing a word (monadic verb)


NB. av, adv, and Adv...
d=. (a0=. `'') (a1=. (@:[) ((<'&')`) (`:6)) (a2=. (`(<(":0);_)) (`:6))
av=. ((af'a0')`)  (`(af'a1')) (`(af'a2') ) (`:6)
  NB. Adverbing a monadic verb (adv)
  assert 1 4 9 -: 1 2 3 *: av

aw=. < o ((0;1;0)&{::)  NB. Fetching the atomic representation (monadic verb)

u (a3=. (o (train o aw f.)) ('av'f.))
  NB. train o aw  gets the (noun or verb) argument

adv=. train o ((af'c') ; ] ; (af'a3')c) f.av
  NB. Adverbing a wicked verb to produce words directly   (adv)
  NB. The argument N of the controlling verb  u  is the argument of the adverb
  NB. u adv  and  u  applied to its argument should produce the desired word.
  NB. Hence, expression  N  u adv  produces the desired word (even if N is a verb),
  NB. for instance,  ]adv  is the Identity adverb.
  erase 'd a0 a1 a2'

  assert ^&* <adv -: (^&*       ]                                 adv <adv)
  assert 1 2 3    -: 1 2 3      ]                                 adv
  assert ^&* <adv -: < o train  ^&* train inv                     adv
  assert 1 4 9    -: 1 2 3      *:                                adv
  assert 6        -: *          (,^:(0:`(<'/')))                  adv 1 2 3
  assert 0 1 3    -: (*:`(+/\)) (train f. o (0&{ , (<'-') , 1&{)) adv 1 2 3

rv=. [^:((,'_:') -: ])L:_ 0

Adv=. (`'') ("_) (((an f.)`(rv f.))`) (`:6) (train f. @:) f.adv
  erase'rv'
  assert  ((v    (_:"_) Adv) <adv) -: v"_ <adv
  assert  ((v _  (_:" ) Adv) <adv) -: v"_ <adv  NB. (_:") Adv is a double Curried adverb
  assert ~: (%@%:@:(1 + %@%:) - (%@%:) _:@:(1 + _:)Adv)(^:_) 1

Fix=. fix o ": f. NB. Fixing verbs, adverbs, and conjunctions directly (monadic verb)
  assert (CRLF ":adv)             -: CRLF
  assert (Fix < o Fix adv)        -: (Fix < o fix adv) NB. Fixing a verb
  assert (< o Fix o train <'adv') -: (< o fix 'adv')   NB. Fixing an adverb
  assert (< o Fix o train <'adv') -: (< o fix 'adv')   NB. Fixing a conjunction


NB. hg...

a3=. (o (aw f.)) ('av'f.) NB. aw  gets the ar of the (noun or verb) argument

hg=. (train f. @:) (train o ((af'c') ; ] ; (af'a3')c) f.av)  NB. Curried
  NB. Adverbing a verb to produce words indirectly (adv)
  NB. The workhorse verb  u  acts on the atomic representation of the
  NB. argument of the adverb  u hg  and should produce the atomic representation of the 
  NB. desired word.  For instance,  ]hg  is the Identity adverb.

  assert ^&* <adv -: (^&*       ]                                  hg <adv)
  assert ^&* <adv -: (^&*       ]                                 adv <adv)
  assert 1 2 3    -: 1 2 3      ]                                  hg
  assert ^&*`''   -: , ^&*      train inv                          hg
  assert 1 4 9    -: 1 2 3      ((<'*:') ; ]   )                   hg
  assert 6        -: *          (< , ((<'/')c))                    hg 1 2 3
  assert 0 1 3    -: (*:`(+/\)) (0&{ , (<'-') , 1&{)@:(('';1)&{::) hg 1 2 3


NB. cv...

cv=. (<adv) ("_) (>@:)
  NB. Constant word (adv)
  NB. cv is to words as c is to nouns
  assert (CRLF cv _)      -: CRLF
  assert (u    cv _) <adv -:      u         <adv
  assert (u    cv  ) <adv -: (>@:(u <adv c))<adv
  assert (!@#  cv _) <adv -: !@# <adv
  assert (< o ((Ver'cv') o train <'/') _) -: ( < o train (<'/'))
  assert (< o ((Ver'cv') o train <'"') _) -: ( < o train (<'"'))


NB. Fetch and From...

pointers=. (<: o - o i.)`i. @.(0<])

Fetch=. (] amper {:: cv)e o pointers f.adv  NB. Verbs mnemonics pointers
  NB. (e.g., ( 'u0 u1 u2 u3'=. 4 Fetch ) j ( 'v0 v1 v2 v3'=. _4 Fetch ) )
  assert (< o train  3 Fetch) -: ( 0&({::)  1&({::)  2&({::)) (< adv)
  assert (< o train _3 Fetch) -: (_3&({::) _2&({::) _1&({::)) (< adv)

From=.  (] amper {   cv)e o pointers f.adv  NB. Verbs mnemonics pointers
  NB. From=.  (] ([ amper train y)(({  `'')c))e o i. f. adv
  NB. (e.g., ( 'u0 u1 u2 u3'=. 4 From ) j ( 'v0 v1 v2 v3'=. _4 From ) )
  assert (< o train  3 From ) -: ( 0&{      1&{      2&{     ) (<adv)
  assert (< o train _3 From ) -: (_3&{     _2&{     _1&{     ) (<adv)

Left=.  (at [cv)e f.adv
  assert (2 Fetch Left ) -: (0&({::)@:[ <adv),(1&({::)@:[ <adv)
Right=. (at ]cv)e f.adv
  assert (2 Fetch Right) -: (0&({::)@:] <adv),(1&({::)@:] <adv)

NB. Monadic and dyadic recursive scope adverbs...

mRS=. (`'') (<&.:train f.av) (`,)(`])            (`:6) (train f. @: ) (&:(an f.))
  NB. Monadic recursion scope
  assert    (1 + (1:`(* $:@<:)@.*)         mRS  4) -: 25  NB. Factorial fixed
dRS=. (`'') (<&.:train f.av) (`,) (`]) (,`) ([`) (`:6) (train f. @: ) (&:(an f.))
  NB. Dyadic recursion scope
  assert (3 (1 + (1:`(%~ * $:&:<:)@.(*@:[))dRS) 7) -: 36  NB. Binomial  fixed

NB. Train forms...

h2g=. (@: ((0;1) {:: tie f. &'')) 'adv'f.                 NB. Hook to gerund
  assert (u       v)           ] h2g      -:     u`      v
  assert (< (1 - ]))           ] h2g      -:     <`(1 - ])
  assert (u       v) at&>/ o box h2g <adv -:    (u@:     v)<adv

h2b=.  @:(box f.)(@: ((0;1) {:: tie f. &'')) 'adv'f.      NB. Hook to boxed
  NB. h2b=. (@:(((0;1;0)&({::) box@:j (0;1;1)&({::))@:tie&'' f.)) 'adv'f.
  assert (u       v)           ] h2b      -: box u`      v
  assert (< (1 - ]))           ] h2b      -: box <`(1 - ])

NB. Recursive version
rec=. ((}: , ($: o , o {:))^:(1 < L.)) o ((0;1)&{::) mRS
t2g=. (@: (rec f. o (tie f.)&'')) 'adv'f.                 NB. Train to gerund
  erase'rec'
  assert (u v)               ]t2g -: (u v) ]h2g
  assert (u0 u1 u2 u3 u4 u5) ]t2g -: u0`u1`u2`u3`u4`u5


NB. Primitive recursive version
NB. filter23=. -. o ((,'2')&-: +. (,'3')&-:)&> # ]
filter23=. -. o ((,'2')&-: +. (,'3')&-:)&> # ]
t2g=. (@:(filter23 f.@:(<S:0 o tie f.&''))) 'av'f.
  erase'filter23'
  assert (u v)               ]t2g -: (u v) ]h2g
  assert (u0 u1 u2 u3 u4 u5) ]t2g -: u0`u1`u2`u3`u4`u5


t2b=. (@:(box f.)) f. ('t2g'f.)                           NB. Train to boxed
  assert  ((u0 u1 u2 u3 u4) ]t2b) -: (box u0`u1`u2`u3`u4)

ats=. > o (at~ e/) o |. f.t2b
  assert (u0 u1 u2 u3 u4 u5)ats <adv -: u0@:u1@:u2@:u3@:u4@:u5 <adv

NB. Strand (of (verbs/noun)s) forms...

s2b=. (train f.@:((train f.@:(] ; (<'cv')c ; (j~)cv ; ]cv )    ) ; (<'adv')c )     adv)
  NB.             (           v      cv       j~      ]        )      adv
  NB. Strand to boxed
  NB. s2b=. ([:         ([:         ]   (cv an)c   (j~)cv   ]cv Train)   (adv an)c Train adv)
  NB. s2b=. (train   @:((train   @:(] ; (cv an)c ; (j~)cv ; ]cv )    ) ; (adv an)c )     adv)
  assert (u v s2b) -: box u`v
  assert (u (an 0) s2b) -: (u <adv) , <0


slash=. Ver'/'  NB. Verbing /

NB. Strand to conjunction...

v0=. train o ((slash o amper >cv) o > o {: ; an o }:)
  assert     ((at      &:    >/ ) box u`v)<adv -: (u@:v)<adv
  assert     (v0 box u`v`at)              <adv -: (u@:v)<adv
  NB. assert ((at      &:    >/ ) [: u v ]sb)     (u@:v) Match
  NB. assert (v0 [: u v at ]sb)                   (u@:v) Match  

a0=. v0@:
v2=. (Ver'adv') o (train f.cv at ])
  NB. The adverbs  (train f. @: u) adv  and  u v2 adv  Match
a2=. v2 adv
v3=. train o (an ;  (,~)cv ; < cv) o <
      assert     (at<adv ,~      <   )<adv -: (at v3 adv)<adv
  NB. assert (at<adv ,~      <   )        (at v3 adv) Match
v4=.        (an f.cv at ]            ) 
      assert an f.   @:((at<adv) ,~ <)<adv -: (((at<adv ,~ <) v4 adv))<adv
  NB. assert an f.   @:((at<adv) ,~ <)        (((at<adv ,~ <) v4 adv)) Match
v5=. (train o (] ;                      ;cv ; ,~cv cv ; ;cv ; <cv cv))
      assert  ((an f.@:((at<adv) ,~ <)) ;     ,~cv      ;     <cv    )<adv -: ((an f.@:((at<adv) ,~ <)) v5 adv)<adv
  NB. assert  ((an f.@:((at<adv) ,~ <)) ;     ,~cv      ;     <cv    )        ((an f.@:((at<adv) ,~ <)) v5 adv) Match
a543=. v5 o v4 o v3 adv
      assert  (u v at a543 a2 a0 adv        )<adv -: (u@:v)<adv

s2c=. train o (] ; (af&>;:'a543 a2 a0 adv')c) f.adv
      erase'v0 a0 v2 a2 v3 v5 a543'
      assert  (u v at s2c)<adv -: (u@:v)<adv
  NB. assert  (u v at s2c)        (u@:v) Match
  

Match=. -:&:< s2c  NB. Matching words (Curried adv since tacit conjuctions are impossible in J)
                   NB. The advverb Match corresponpods to Jx Wicked Toolkit's match conjunction
  assert u v at s2c  u@:v Match

bw=. < o (fix :: train :: (". o >))"0 o ;:f.  NB. boxing pro-word or primitive (monadic verb)
                                              NB. (e.g., bw'+/"1 2 3' )
  assert (train o (an e) o bw'+/"1 2 3') (+/"1 2 3) Match  NB. Matching verbs
  NB.     > o bw 'for'  NB. for fixed
  NB. < o > o bw 'for'  NB. for pro-adverb!
  
NB. knot...

atomic=. 1: o train :: 0:
ahna=. an ^: (-. o atomic o {.) NB. Atomize if the head is not a tight (using (`:6) instead of (5!:0))
                                NB. atomic representation
knot=. tie &: ahna f.
  erase'ahna'
  
Knot=. knot s2c  NB. (Curried adv since tacit conjuctions are impossible in J)
                 NB. Jx Knot (`.) conjunction
  assert (train + (an o train o <'/') 1 2 3 Knot Knot) -: 6

NB. 77 Wrap's2c'

(9!:3) 5 2  NB. Box (display) and linear representations...

NB. sb...

cap=. [:cv -:&:< [              NB. Is it a cap?
eval=. train o ({: ; (an o }:)) NB. Evaluating a verb form (v N)
next=. > o {:y  train o , &:an~  ;
                                NB. Producing the next adverb
main=. next`(eval o (train :: ] e) o }:y)@.cap f.s2c

sb=. (< o fix 'main') 'main'f.  NB. Strand to boxed (Curried adv with variable arity)
                                NB. Reproducing a variant of itself until a cap in encountered

  assert [: + (an o train o <'/'      )         1 2 3  train o (an&>) sb -: 6
  assert [: + (an o an o train o <'/')   (an an 1 2 3) train          sb -: 6
  assert [: + (an o train o <'/') 1 2 3 ]                             sb -: ((+<adv) , (bw'/') , (<1 2 3))
  assert ( [: u0 u1 u2 (at~&:>/) o |. f.sb ) ( u0@:u1@:u2 ) Match

At=. train o (at~&:>/) o |. f.sb  NB. (Curried adv)
  assert [: u0 u1 u2 u3   At  u0@:u1@:u2@:u3  Match
  assert [: u1 u2 (u3 u4) At  u1@:u2@:(u3 u4) Match
  assert [: u             At  u               Match

Train=. (train cv at ]) o (train o (train o ([ ; ;cv ; ])/)) f.sb
  NB.Train=. (train cv at ]) o ([: [ ;cv ] Train     /) f.sb  NB. (Curried adv)
  assert [: u0          Train  train @:(u0               ) Match
  assert [: u0 u1 u2 u3 Train  train @:(u0 ; u1 ; u2 ; u3) Match

NB. snb...

C=. _2                              NB. Counter position
last=. _1 >: C&{::                  NB. Is the last word in the queue?
dec=.  < o <: o (C&{::)  C}  ]      NB. Decrementing the counter
next=. > o {: y  train o , &:an~  dec o ;
                                    NB.  Producing the next adverb
main=. next`(eval o (train :: ] e) o (_2&}.) o ;)@.((last :: 0:)y) f.s2c

snb=. (< o train <'main')  main
snb=. (< o fix    'main') 'main'f.  NB. Strand to boxed (Curried adv)
  assert (u v      (at&:>/) 2 snb ) (u v at s2c) Match
  assert (u0 u1 u2  train   3 snb ) (u0 u1 u2  ) Match
  assert (u0 u1 u2 (train   3 snb)) (u0 u1 u2  ) Match

  erase'cap eval main'

NB. xadvy...
 
ba=. <adv

NB. Form: ba (&(u o ,)) q

xadvy=. [: ( <'ba')c  an o ([: (<'&')c  (] at   ,cv) Train)  ( <'q')c Train   adv
xadvy=. [: (af'ba')c  an o ([: (<'&')c  (] at f.,cv) Train)  (af'q')c Train f.adv NB. (Curried adv)
  NB.   (      ba     (           &      u @:   ,         )      q        )
  assert (    u ] xadvy 3 4 5) (    u (ba (&(] o ,)) q) 3 4 5) Match
  assert (1 2 u ] xadvy 3 4 5) (1 2 u (ba (&(] o ,)) q) 3 4 5) Match

NB. Form: ba (&(u o ,)) d)

d=. (@:,)(&:(an f.))
xadvy=. [: (af'ba')c  an o ([: (<'&')c  (] at f.,cv) Train)  (af'd')c Train f.adv NB. (Curried adv)
  NB.   (      ba     (           &      u o    ,         )      d        )          
  assert (    u ] xadvy 3 4 5) (    u (ba (&(] o ,)) d) 3 4 5) Match
  assert (1 2 u ] xadvy 3 4 5) (1 2 u (ba (&(] o ,)) d) 3 4 5) Match
  erase 'd ba'
  'X Y'=. ;:'X Y'
  assert (  u ]xadvy Y) -: (u <adv ,           an Y )
  assert (X u ]xadvy Y) -: (u <adv , (an X) , (an Y))

fg=. > o (tie e/) o (fix :: ] e) o box f. 
  NB. Producing a gerund by fixing the verbs of a typical gerund
fg=. fix :: ] e &.: box f.     NB. Fix gerund (monadic verb)
  NB. Fixing, if necessary, the components of a gerund
  NB. WARNING: Producing a gerundive instead of a gerund
  assert (fg (j`(;:'for')`(;:'"')`(an _)))`:6  ,&:<"1@:(>@:{)"_ Match

NB. Fix agenda...

G=. (0;1;0)&({::)              NB. Fetching the gerund              
C=. (0;1;1)&({::)              NB. Fetching the case                
head=. fg      o train o < o G NB. Fixing the gerund                
tail=. fix ::] o train o < o C NB. Fixing the case
agenda=. Ver'@.'                  
                                                                    
fa=. (head agenda tail) o (tie&'') f.adv  NB. Fixing agenda                          
  erase'G C head tail'
  increment =. [: $: >:                                               
  result =. ]                                                         
  choose =. 3 < | 
NB.  assert (increment`result@.choose fa)    (([: $: >:)`]@.(3 < |))  -:&:":  s2c  NB. They look the same...
  assert (increment`result@.choose fa)       (([: $: >:)`]@.(3 < |)) (1 - -:) s2c  NB. But they are no
  assert (increment`result@.choose fa mRS -:  ([: $: >:)`]@.(3 < |)mRS) _3         NB. Yet, their products match            

NB. ..............................................................................................
NB. .. Alternative definitions for gTxt, nest2Box and ae
NB.
NB. .. No subject [!]
NB. .. http://www.jsoftware.com/pipermail/general/2009-April/033220.html
NB. .. http://www.jsoftware.com/svn/DanBron/trunk/environment/anonymous_evoke2.ijs                                       ..
NB. ..............................................................................................

parencuts=. _1 |. 0 = 1 _1 0 +/\@:{~ (;:'()') i. ]   NB. (monadic verb)
parensen=. < o $: o }. o }:                          NB. (monadic verb)
anonymousnoun=. ('''' = {.) +. (':' ~: {:) *. '_0123456789' e.~ {.
parenthesized=. (;:'()') -: {. , {:                  NB. (monadic verb)
dropNB=. }: ^: ('NB.' -: 3 {. > o {:)

gTxt=. (an o ".^:anonymousnoun)L:0 o dropNB o ;: f.  NB. (monadic verb)

'agenda cut'=. Ver'@. ;.'  NB. Verbalizing agenda (@.) and cut (;.)

recurse=. parensen ((Ver'mRS') o (,cv at ([: parencuts f.cv ((tie&:fix p agenda parenthesized f.cv) cut 1:) ]cv Train))) 2 snb
  NB. The adverb recurse produces fixable and embeddable recursive verbs
  simple=. ] 
  assert (simple recurse) ((,@:(parencuts f. (simple f.)`(parensen f.)@.parenthesized f.;.1 ]))('mRS'f.)) Match

nest2Box=. ] recurse o (] [^:((;:'()') e.~ [)"_1 <"0 o i. o #y) f.
  assert ( ([ agenda nest2Box) o gTxt lr'toJ')  (toJ  f.) Match  
  assert (< o ([ agenda nest2Box) o gTxt lr'for') -: (< o fix 'for')

simple=. an o ". ^: anonymousnoun o ; &.: >          NB. (monadic verb)

as=.  simple recurse o dropNB o ;: f.                NB. (monadic verb)
  assert (    train o as '%:@:u') (%:@:u ) Match
  assert (< o train o as '/'    ) ( < o train o ;:'/ ') Match
  assert (train o as o lr'toJ'  ) (toJ f.) Match

erase'parencuts parensen anonymousnoun simple parenthesized recurse'

ae=. train o as f.av  NB. Anonymous evoke
ae=. (as f.av) (`:6)
  assert (lr'toJ')ae (toJ f.) Match


indices=. train"0 o ((1 -: L.)S:1 # <S:1) o (tie&'') o fix :: ] x NB. (ambivalent verb)

single=. 1 -: #  NB. (monadic verb)

z=. ((an'')`($ ,)`)(`:6)

f=. ((] amper {cv) o indices) f.adv
  NB. This adverb fetches several items of a list

  'A B C X Y Z'=. (3 Fetch) , (3 From)
  assert (A B C)f  0 1 2&{   Match
  assert (X Y Z)f  0 1 2&{   Match

  NB. Direct implementation of twice (^:2)
  NB. https://en.wikipedia.org/wiki/Higher-order_function#Direct_support
  'U Y'=. 2 Fetch
  twice=. train o ((U U Y)f) f.xadvy
  assert  ((+&3) twice 7) -: 13
  erase 'twice'


notfroming=. ((<,'{') -. o -: {:) o (< S:1) o (tie&'') o fix :: 1: x NB. (ambivalent verb)

brace=. Ver'}'

h=.   [: ]`         (<cv at ]) @. (notfroming *. single o indices) (]z^:single) o indices (brace o) ]cv Train f.s2c
  NB. The hold conjunction simulates assigment of one or several items of a list

  NB.    v           <   @: v                                                         ...  }        ]
  NB. (Curried adv since user defined tacit conjuctions are impossible in J)
  NB. Jx h (`.) conjunction 
  NB.   
  NB.    multiple u  single u


  assert (  A      v h) (  <@:v 0} ] ) Match
  assert ( (A B C) v h) ( v 0 1 2} ] ) Match
  assert (  A      v h) (  <@:v 0} ] ) Match
  assert ( (A B C) v h) ( v 0 1 2} ] ) Match

  assert (       X v h) ( v 0    } ] ) Match
  assert ( (X Y Z) v h) ( v 0 1 2} ] ) Match

erase 'indices single'

local=. (,cv amper ;: o ":) f.adv
  NB. local=. (,cv amper (<S:0)) o ((rc dr)ver o Fix) f.adv
  assert(A local 0;1) -: (0;1;(,'A'))
  assert ((A B C)local 0;1) -: (0;1;(,'A');(,'B');,'C')


NB. Processing noun scripts...

gn=. ". o ('0( : 0)'c)  NB. Get noun (niladic verb)
  NB.       0  : 0  causes coloring problems in JQt
  assert (gn'') -: 32 32 65 66 67 10 32 32 49 50 51 52 53 54 55 56 57 48 10{a.
  ABC
  1234567890
  )


NB. tv ...
gn=. ". o ('0( : 0)'c)  NB. Get noun (niladic verb)
  NB.       0  : 0  causes coloring problems in JQt
  assert (gn'') -: 32 32 65 66 67 10 32 32 49 50 51 52 53 54 55 56 57 48 10{a.
  ABC
  1234567890
  )

NB. stp...

u=. ([ ((<;._1 '|Sentence|Space|Time|Space * Time') , (, */&.:>@:(1 2&{))@:(] ; 7!:2@:] ; 6!:2)&>) (10{a.) -.&a:@:(<;._2@,~) ])
v=. ((assert o (2 -:/\ ]) o (".&.>) o ((10{a.) -.&a:@:(<;._2@,~) ])) :: (echo o ('Mismatch!'c)))

stp=. (] (u [ v) gn)f.  NB. Space time performance asserting that all noun results match (monadic verb)
erase'u v'


pn=. ([: at an o gn c Train) f.s2c NB. Process explicit noun (adv)
  assert (, ((;: ;._2) pn)) -: ;:'zero one'
zero
one
)

fel=. (a:&(-. o -:))"0 # ]

tv=.  train o (at~&:>/) o ((train o as)e) o fel o (< o (;: inv) o dropNB o ;: ;._2) pn

NB. Redefining tv on its own terms...

tv=. ]tv f.pn  NB. Tacit verb (adv)

  NB. The following lines define the verb preceding pn...

  < o (;: inv) o dropNB o ;: ;._2  NB. Dropping the NBs and boxing the lines
  (a:&(-. o -:))"0 # ]             NB. Filtering empty lines
  train o as e                     NB. Boxing the verbs (one verb per line)
  at~&:>/                          NB. Inserting at (@:) between the verbs
  train                            NB. Allowing a single effective line
)

erase'fel'


NB. Xi...

'A B C'=. 3 Fetch Right
amend=. (0: A f.`(<@:B f.)`(C f.)} ]) f.

'P E I W'=. 4 Fetch

eval=. [tv f.
  , <                            NB. Producing the working list (P E I W)
  (W P) ((# o E ~: > o P) (([ # W y) j ([ < o # > o P y)) ]) h
    NB. Removing mute parameters and corresponding words
  E (amend o ((W P E)f)) h      NB. Replacing the parameters (named arguments) by their arguments
  E agenda I                    NB. Producing the word implied by the (gerundial form of the) sentence
)

NB. Dark horse...

ei=. (j nest2Box)@:gTxt         NB. Elements and indices for the agenda
compress=. (j~.)x (1&{::x j ((1&{::x i. (] { 0&{::x))L:_ 0)) ] NB. (dyadic verb)
                                NB. Compressing the elements and indices into an equivalent pair
cei=. (compress nest2Box)@:gTxt NB. cei=. compress p o ei

'Y W E I'=. 4 Fetch

dh=. [tv
  <
  (W E I)local
  W     (":e o }: o Y    ) h    NB. Producing the pro-words
  (E I) (cei o > o {: o Y) h    NB. Producing the sentence's compressed elements and indices
  W     (< o (E i."_ 0 W)) h    NB. Producing the indices corresponding to the pro-words
                                NB. Y persists just as a place holder
)

bondat=. (((W E I)f) amper eval f. cv) at (an f. e cv)  NB. Bonding W E I to eval and piping (an e) 
  NB.     ((W,E,I)   &     eval f.   ) @: (an    e   )

xi=.    ((bondat o dh f.)(an adv)) sb   NB. Instead of ( xi=. bondat o dh f. sb ) to save space!

  assert (     [: u   '2+3'    xi _                      )  5                  Match
  assert (     [: u v 'v/ + v' xi [:  _        *: o + ]sb) (*:@:+/ + *:@:+   ) Match
  assert      ([: u v 'u + v'  xi [: (2)     (3)      ]sb)  5                  Match
  assert      ([: u v 'u + v'  xi [:  2       %       ]sb) (2 + %            ) Match
  assert      ([: u v 'u + v'  xi [:  *       %       ]sb) (* + %            ) Match
  assert      ([: u v 'u   v'  xi [:  *:      +/      ]sb) (*: +/            ) Match
  assert      ([: u v 'u   v'  xi [:  *:     (as'"_') ]sb) (*: "_            ) Match
  assert (< o ([: u v 'u   v'  xi)[: (;:'"')  _       ]sb) (< o (Ver'ae')'"_') Match
  assert (1) (2) (3) ([: y0 y1 y2 'y0 - y1 % y2'xi 3 snb) -: %3

  NB. Beware... [: u 'u [: u ]sb' xi [: [: u 'u [: u ]sb' xi ]sb !


erase e o <"0'ABCDEFGHIJKLMNOPQRSTUVWXYZ'

lrw=. (_2 }. ":) o (rank&_)

k=. (] [ (". o ([ , '=. ' , lrw y)) f.)
  assert T       -:     'T'       k        <"0 i.3 5
  assert test f. ('test' ([ k fix y) 'an'     ) Match

